# PlacetGroup Module - Upgrade to v2.0.0 for PrestaShop 8.1.6

## Changes Made for PrestaShop 8.1.6 Compatibility

### Version Update
- **Module version:** Updated from `1.3.0` to `2.0.0`
- **Compatibility range:** Changed from `1.6 - current` to `1.7.0 - 8.99.99`

### Critical Changes

#### 1. Removed Deprecated Hook
- **Removed:** `hookPayment()` method (deprecated since PS 1.7, removed in PS 8.x)
- **Using:** `hookPaymentOptions()` exclusively for payment display
- **Impact:** Module now fully compatible with PS 8.x payment system

#### 2. Updated Hook Registration
**Install method:**
- Removed: `registerHook('payment')`
- Kept: `registerHook('paymentOptions')`, `registerHook('paymentReturn')`, `registerHook('displayPaymentReturn')`

**Uninstall method:**
- Removed: `unregisterHook('payment')`
- Added: `unregisterHook('displayPaymentReturn')`
- Kept: `unregisterHook('paymentReturn')`, `unregisterHook('paymentOptions')`

#### 3. PHP Version Requirement
**composer.json updates:**
- **Old:** `php >= 5.3.2`
- **New:** `php >= 7.2.5`
- **Reason:** PrestaShop 8.1.6 requires PHP 7.2.5+ (recommended PHP 8.0+)

#### 4. Improved SQL Security
Converted raw SQL queries to use `DbQuery` builder pattern for better security:

**PlacetApplication::getIdByToken($token):**
```php
// Old: Raw SQL with string concatenation
$request = "SELECT `id_placet_application` FROM `"._DB_PREFIX_."placet_application`
WHERE `token` = '$token'
ORDER BY `date_upd` DESC";

// New: Using DbQuery builder
$sql = new DbQuery();
$sql->select('id_placet_application')
    ->from('placet_application')
    ->where('token = "'.pSQL($token).'"')
    ->orderBy('date_upd DESC');
```

**PlacetApplication::getCartsLatestToken($cartId):**
```php
// Old: Raw SQL with string concatenation
$request = "SELECT `token` FROM `"._DB_PREFIX_."placet_application`
WHERE `id_cart` = '$cartId'
ORDER BY `date_upd` DESC";

// New: Using DbQuery builder
$sql = new DbQuery();
$sql->select('token')
    ->from('placet_application')
    ->where('id_cart = '.(int)$cartId)
    ->orderBy('date_upd DESC');
```

#### 5. Updated Module Metadata
**composer.json:**
- Updated package name: `placetgroup/prestashop-module`
- Updated description: "PrestaShop Placet Group payment module"
- Updated license: `Commercial`
- Updated author information to Placet Group

#### 6. PHP 8.2+ Compatibility - Property Declarations
Added explicit property declarations to fix PHP 8.2+ deprecation warnings:
- `public $is_eu_compatible` - EU compliance flag
- `public $controllers` - Module controllers array
- `public $currencies` - Currency support flag
- `public $currencies_mode` - Currency display mode
- `public $bootstrap` - Bootstrap UI flag

**Reason:** PHP 8.2+ deprecates dynamic property creation. All class properties must be explicitly declared.

#### 7. PrestaShop 8.x Hook Parameter Compatibility
Fixed `hookPaymentReturn` and `hookDisplayPaymentReturn` to work with both PS 1.7 and PS 8.x parameter names:

**Parameter changes in PS 8.x:**
- `objOrder` → `order`
- `currencyObj` → `currency`
- Added null checks and fallbacks for backward compatibility

**Code:**
```php
// PrestaShop 8.x uses 'order' instead of 'objOrder'
$order = isset($params['order']) ? $params['order'] : (isset($params['objOrder']) ? $params['objOrder'] : null);

// PrestaShop 8.x uses 'currency' instead of 'currencyObj'
$currency = isset($params['currency']) ? $params['currency'] : (isset($params['currencyObj']) ? $params['currencyObj'] : null);
```

**Impact:** Fixes fatal error "Call to a member function getCurrentState() on null" on order confirmation page in PrestaShop 8.x

## Testing Checklist

Before deploying to production, verify:

- [ ] Module installs without errors on PS 8.1.6
- [ ] Module uninstalls cleanly
- [ ] Payment option displays correctly at checkout
- [ ] Complete payment flow works (initiate → redirect → return)
- [ ] Order creation works with custom order states
- [ ] Status updates from Placet API work correctly
- [ ] Return URLs (success/error) function properly
- [ ] No PHP errors in logs
- [ ] Compatible with PHP 7.2.5, 7.4, 8.0, 8.1, 8.2+

## Backward Compatibility

⚠️ **Breaking Changes:**
- No longer compatible with PrestaShop 1.6.x
- Minimum PrestaShop version: 1.7.0
- Minimum PHP version: 7.2.5

✅ **Maintained Compatibility:**
- All existing payment flows preserved
- Database structure unchanged
- API integration unchanged
- Order states unchanged

## Migration Instructions

### For Fresh Installation
1. Upload module to `/modules/placetgroup/`
2. Install via PrestaShop back office
3. Configure Placet URL and Partner Alias
4. Test payment flow

### For Upgrading from v1.3.0
1. Backup your database
2. Backup current module folder
3. Replace module files with new version
4. Clear cache (Symfony and Smarty)
5. Test thoroughly on staging environment

## Support

For issues related to this upgrade:
- Check PrestaShop logs: `/var/logs/`
- Check Apache/PHP error logs
- Review module logs: `/modules/placetgroup/[date].log`

## Technical Details

### Files Modified:
1. `placetgroup.php` - Main module file
2. `classes/PlacetApplication.php` - Database model
3. `composer.json` - Dependencies and metadata

### Files Removed:
1. `controllers/front/paymentPlacet.php` - Leftover Skrill module code (non-functional)
2. `controllers/front/paymentReturn.php` - Unused bankwire controller (non-functional)

### Files Unchanged:
- Active controller files (validation, return, iframe)
- All template files
- SQL installation scripts
- Translation files

### Note on Leftover Code:
The module contained some leftover template code from other payment modules (Skrill/Bankwire). The non-functional controller files have been removed. Some template comments still reference Skrill but these don't affect functionality.

### Dependencies:
- PrestaShop 1.7.0 - 8.99.99
- PHP 7.2.5+
- cURL extension
- MySQL 5.6+ or MariaDB 10.0+

---

**Upgrade Date:** October 24, 2025  
**Module Version:** 2.0.0  
**Target Platform:** PrestaShop 8.1.6

