<?php
/**
 * NOTICE OF LICENSE
 *
 * This module was created by Placet Group and is protected by the laws of Copyright.
 * This use license is granted for only one website.
 * To use this module on several websites, you must purchase as many licenses as websites on which you want to use it.
 * Use, copy, modification or distribution of this module without
 * written license agreement from Placet Group is strictly forbidden.
 * In order to obtain a license, please contact us: info@placetgroup.com
 * Any infringement of these provisions as well as general copyrights will be prosecuted.
 * ...........................................................................
 *
 *
 * @author     Placet Group <info@placetgroup.com>
 * @copyright  Copyright (c) 2023 Placet Group
 * @license    Commercial license
 */

class PlacetApplication extends ObjectModel
{
    /** @var string Application token obtained from Placet Group */
    public $token;

    /** @var int Cart id */
    public $id_cart;

    /** @var int Order id */
    public $id_order;

    /** @var float Total to pay */
    public $cart_total;

    /** @var int Customer currency ID */
    public $id_currency;

    /** @var string Placet Group Application status ("new" / "approved" / "declined") */
    public $application_status;

    /** @var string Object last modification date */
    public $date_upd;

    public static $definition = array (
        'table' => 'placet_application',
        'primary' => 'id_placet_application',
        'fields' => array(
            'token' => array('type' => self::TYPE_STRING, 'validate' => 'isCatalogName', 'size' => 128, 'required' => true),
            'id_cart' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'id_order' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),
            'cart_total' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice', 'required' => true),
            'id_currency' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'application_status' => array('type' => self::TYPE_STRING, 'validate' => 'isCatalogName', 'size' => 12),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDate')
        )
    );

    public static $statusMap = [
        'new' => [
        ],
        'approved' => [
             'ps_status' => 'PS_OS_PAYMENT'
        ],
        'declined' => [
            'ps_status' => 'PS_OS_PLACETGROUP_REJECTED'
        ],
    ];

    public function __construct($id_placet_application = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_placet_application, $id_lang, $id_shop);
    }

    public static function getByToken($token)
    {
        $token = pSQL($token);
        if (!$idApplication = PlacetApplication::getIdByToken($token)){
            $errorMessage = sprintf('Missing PlacetApplication with token %s', $token);
            PrestaShopLogger::addLog($errorMessage, 3, null, null, null, true);
            return false;
        }

        $placetApplication = new PlacetApplication($idApplication);
        if(!Validate::isLoadedObject($placetApplication)){
            $errorMessage = sprintf('Failed loading PlacetApplication with token %s', $token);
            PrestaShopLogger::addLog($errorMessage, 3, null, null, null, true);
            return false;
        }

        return $placetApplication;
    }

    public static function getIdByToken($token)
    {
        $token = pSQL($token);
        
        $sql = new DbQuery();
        $sql->select('id_placet_application')
            ->from('placet_application')
            ->where('token = "'.pSQL($token).'"')
            ->orderBy('date_upd DESC');

        return Db::getInstance()->getValue($sql);
    }

    public static function getCartsLatestToken($cartId)
    {
        $cartId = (int)$cartId;
        if (!$cartId) {
            return false;
        }
        
        $sql = new DbQuery();
        $sql->select('token')
            ->from('placet_application')
            ->where('id_cart = '.(int)$cartId)
            ->orderBy('date_upd DESC');

        return Db::getInstance()->getValue($sql);
    }

    public function updateStatus($status)
    {
        $status = pSQL($status);
        if(!isset(PlacetApplication::$statusMap[($status)])){
            $errorMessage = sprintf("Attempted setting PlacetApplication to invalid status: '%s'", $status);
            PrestaShopLogger::addLog($errorMessage, 3, null, null, null, true);
            return;
    }

        if ($this->application_status === $status) {
            return;
        }

        $this->application_status = $status;
        $result = $this->save();
        if(!$result){
            $errorMessage = sprintf('Failed saving setting PlacetApplication status \'%s\'', $status);
            PrestaShopLogger::addLog($errorMessage, 3, null, null, null, true);
            return;
        }

        return;
    }
}
