<?php
/**
 * NOTICE OF LICENSE
 *
 * This module was created by Placet Group and is protected by the laws of Copyright.
 * This use license is granted for only one website.
 * To use this module on several websites, you must purchase as many licenses as websites on which you want to use it.
 * Use, copy, modification or distribution of this module without
 * written license agreement from Placet Group is strictly forbidden.
 * In order to obtain a license, please contact us: info@placetgroup.com
 * Any infringement of these provisions as well as general copyrights will be prosecuted.
 * ...........................................................................
 *
 *
 * @author     Placet Group <info@placetgroup.com>
 * @copyright  Copyright (c) 2023 Placet Group
 * @license    Commercial license
 */

class PlacetgroupReturnModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        // get token
        $token = null;
        $raw = file_get_contents('php://input');
        $json = json_decode($raw);

        if (!empty($json->notification->token)) {
            if (false) {
                // Keeping for future use
                $this->module->writeLog($json, 'JSON:', false);
            }
            $token = $json->notification->token;
        }

        if (empty($token)){
            $token = Tools::getValue('requestToken');
        }

        if (empty($token)){
            $context = Context::getContext();
            $cart = $context->cart;
            $errorMessage = sprintf(
                'Missing return token/requestToken parameter for cart %s',
                $this->module->getVarFormat($cart->id, 'id_cart'));

            PrestaShopLogger::addLog(
                $errorMessage, 3, null, "Cart",
                $cart->id, true);

            // redirect away
            $this->display_column_left = false;
            $this->process();
            if (!isset($this->context->cart)) {
                $this->context->cart = new Cart();
            }
            Tools::redirect(
                $this->context->link->getPageLink('order', true, null, array('step' => '3'))
            );
        }

        $order = $this->module->handleApplication($token);


        if(empty($order)){
            if (!isset($this->context->cart)) {
                $this->context->cart = new Cart();
            }
            Tools::redirect(
                $this->context->link->getPageLink('order', true, null, array('step' => '3'))
            );
        } else {
            $link = $this->module->getOrderConfRedirectLink($order);
            if (!empty($link)){
                Tools::redirect($link);
            }
        }

        // fin for callback
        die ('success');
    }
}
