<?php
/**
 * NOTICE OF LICENSE
 *
 * This module was created by Placet Group and is protected by the laws of Copyright.
 * This use license is granted for only one website.
 * To use this module on several websites, you must purchase as many licenses as websites on which you want to use it.
 * Use, copy, modification or distribution of this module without
 * written license agreement from Placet Group is strictly forbidden.
 * In order to obtain a license, please contact us: info@placetgroup.com
 * Any infringement of these provisions as well as general copyrights will be prosecuted.
 * ...........................................................................
 *
 *
 * @author     Placet Group <info@placetgroup.com>
 * @copyright  Copyright (c) 2023 Placet Group
 * @license    Commercial license
 */

/**
 * @since 1.5.0
 */
class PlacetGroupValidationModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $cart = $this->context->cart;
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
            exit;
        }

        // Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'placetgroup') {
                $authorized = true;
                break;
            }
        }

        if (!$authorized) {
            die($this->module->l('This payment method is not available.', 'validation'));
        }

        $this->context->smarty->assign([
            'params' => $_REQUEST,
        ]);

        //$this->setTemplate('payment_return.tpl');
        //$this->setTemplate('module:placetgroup/views/templates/front/payment_return.tpl');


        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
            exit;
        }    

        $context = Context::getContext();
        $currency = $context->currency;

        if ('EUR' !== $currency->iso_code) {
            Tools::redirect('index.php?controller=order&step=1');
            exit;
        }


        $total = (float)$cart->getOrderTotal(true, Cart::BOTH);

        $this->module->validateOrder(
            $cart->id,
            Configuration::get('PS_OS_PLACETGROUP_AWAITING'),
            $total,
            sprintf($this->module->payment_method_label_template, $cart->id),
            NULL,
            array(),
            (int)$currency->id,
            false,
            $customer->secure_key
        );

        $order = new Order($this->module->currentOrder);
        if(!Validate::isLoadedObject($order)){
            $errorMessage = sprintf('Failed Creating order for cart Id %s', $cart->id);
            PrestaShopLogger::addLog($errorMessage, 3, null, null, null, true);
            //throw new Exception('Failed creating Order');
            Tools::redirect('index.php?controller=order&step=1');
            exit;

        }

        /*$mailVars = array(
             '{bankwire_owner}' => Configuration::get('BANK_WIRE_OWNER'),
             '{bankwire_details}' => nl2br(Configuration::get('BANK_WIRE_DETAILS')),
             '{bankwire_address}' => nl2br(Configuration::get('BANK_WIRE_ADDRESS'))
        );*/

        $items = array();
        foreach ($cart->getProducts() as $product){
            $items[] = ["name" => $product['name']];
        }
        $ip = $this->getClientIP();
        $params = array(
            "request_token" => array(
                "amount" => floatval($total),
                "locale" => "et",
                "product_items" => $items,
                "client_id" => (string)$order->id_customer,
                "client_ip" => $ip != '::1' ? $ip : '127.0.0.1',
                "success_url" => _PS_BASE_URL_."/index.php?fc=module&module=placetgroup&controller=return&status=success&requestToken=%rt%",
                "error_url" => _PS_BASE_URL_."/index.php?fc=module&module=placetgroup&controller=return&status=error&requestToken=%rt%",
                "notification_url" => $this->context->link->getModuleLink($this->module->name, 'return', [], true),
                "cart_id" => (string)$cart->id,
                "order_id" => (string)$order->id,
            )
        );

        // echo '<pre>';
        // print_r($params);
        // echo '</pre>';
        // die();

        $url = sprintf('%s/%s/requestToken', Configuration::get('placetgroup'), Configuration::get('placetgroup_partneralias'));

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>json_encode($params),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
            ),
        ));

        $responseRaw = curl_exec($curl);
        $httpCode    = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $curlErr     = curl_error($curl);
        curl_close($curl);

        if ($responseRaw === false || $responseRaw === '' || $httpCode < 200 || $httpCode >= 300) {
            PrestaShopLogger::addLog(
                sprintf('Placet requestToken transport error (cart %s): http=%s, curl=%s', $cart->id, $httpCode, $curlErr),
                3
            );
            Tools::redirect('index.php?controller=order&step=1');
            exit;
        }

        $response = json_decode($responseRaw);

        if (!is_object($response) || !isset($response->request_token)) {
            PrestaShopLogger::addLog(
                sprintf('Placet requestToken invalid JSON (cart %s): %s', $cart->id, $responseRaw),
                3
            );
            Tools::redirect('index.php?controller=order&step=1');
            exit;
        }

        $token = null;
        $redirect_url = null;
        if (is_object($response->request_token) && isset($response->request_token->token)) {
            $token = (string)$response->request_token->token;
            $redirect_url = (string)$response->request_token->redirect_url;
        } else {
            $token = (string)$response->request_token;
            $redirect_url = (string)$response->request_token->redirect_url;
        }

        $this->module->createApplicationRecord(
            $token,
            (int)$cart->id,
            (float)$total,
            (int)$currency->id,
            (int)$order->id
        );

        // $base  = rtrim(Configuration::get('placetgroup'), '/');
        // $alias = trim(Configuration::get('placetgroup_partneralias'), '/');
        // $redirectUrl = $base . '/' . $alias . '/' . $token;
        Tools::redirect($redirect_url);
        exit;

    }

    private function getClientIP()
    {
        $keys = array(
            'HTTP_CLIENT_IP',
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_FORWARDED',
            'HTTP_FORWARDED_FOR',
            'HTTP_FORWARDED',
            'REMOTE_ADDR'
        );
        foreach ($keys as $k) {
            if (!empty($_SERVER[$k])) {
                $ips = explode(',', $_SERVER[$k]);
                foreach ($ips as $ip) {
                    $ip = trim($ip);
                    // Validate IPv4 and IPv6, but ignore localhost (::1 and 127.0.0.1)
                    if (
                        filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) ||
                        (
                            filter_var($ip, FILTER_VALIDATE_IP)
                            && $ip !== '::1'
                            && $ip !== '127.0.0.1'
                        )
                    ) {
                        return $ip;
                    }
                }
            }
        }
        // Fallback: check if at least localhost is present
        foreach ($keys as $k) {
            if (!empty($_SERVER[$k])) {
                $ips = explode(',', $_SERVER[$k]);
                foreach ($ips as $ip) {
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP)) {
                        return $ip;
                    }
                }
            }
        }
        return "UNKNOWN";
    }
}
