# Placet Group Payment Extension for OpenCart 3.x

Official payment gateway integration for Placet Group installment payment service.

## 📋 Requirements

- OpenCart 3.0.0.0 or higher
- PHP 7.0 or higher
- cURL PHP extension enabled
- Active Placet Group merchant account
- Store currency must support EUR

## 📦 Installation Instructions

### Step 1: Upload Files

Upload the extension files to your OpenCart root directory, maintaining the folder structure:

```
admin/
  controller/extension/payment/placetgroup.php
  language/en-gb/extension/payment/placetgroup.php
  view/template/extension/payment/placetgroup.twig
catalog/
  controller/extension/payment/placetgroup.php
  language/en-gb/extension/payment/placetgroup.php
  model/extension/payment/placetgroup.php
  view/theme/default/template/extension/payment/placetgroup.twig
system/
  library/placetgroup.php
```

**Upload methods:**
- FTP/SFTP: Upload to your OpenCart root directory
- cPanel File Manager: Upload and extract ZIP
- SSH: Upload via SCP/RSYNC

### Step 2: Install & Configure in Admin Panel

**Note:** The database table is created automatically when you install the extension - no manual SQL execution required!

1. **Install the Extension:**
   - Login to OpenCart Admin
   - Navigate to: `Extensions` → `Extensions`
   - Select extension type: `Payments`
   - Find "Placet Group" in the list
   - Click the green **Install** button (+ icon)
   - **The database table is created automatically at this step!**

2. **Configure the Extension:**
   - Click the blue **Edit** button (pencil icon)
   - Enter your configuration:
     * **API URL:** Your Placet Group API endpoint (e.g., `https://portal.placet.ee/api`)
     * **Partner Alias:** Your merchant alias provided by Placet Group
     * **Status:** Enabled
     * **Sort Order:** Display order in checkout (optional)
     * **Geo Zone:** Select if you want to restrict by location (optional)

3. **Configure Order Statuses:**
   - **Awaiting Payment Status:** Status when payment is initiated (e.g., "Pending")
   - **Approved Payment Status:** Status when payment is successful (e.g., "Processing")
   - **Rejected Payment Status:** Status when payment fails (e.g., "Failed")
   
   **Tip:** Click "Create Custom Order Statuses" button to automatically create Placet Group-specific statuses.

4. **Save Configuration**

### Step 3: Verify Installation

1. **Test in Checkout:**
   - Make sure your store currency is set to EUR
   - Add a product to cart
   - Go to checkout
   - Placet Group should appear as a payment option

2. **Test Payment Flow:**
   - Select Placet Group payment
   - Complete order
   - You should be redirected to Placet Group payment page
   - After payment, you'll return to your store
   - Check order status updates automatically

## 🔧 Configuration Options

| Option | Description | Required |
|--------|-------------|----------|
| API URL | Placet Group API endpoint URL | Yes |
| Partner Alias | Your merchant identifier | Yes |
| Status | Enable/Disable the payment method | Yes |
| Sort Order | Display position in checkout | No |
| Geo Zone | Restrict payment to specific regions | No |
| Awaiting Status | Order status when payment initiated | Yes |
| Approved Status | Order status when payment approved | Yes |
| Rejected Status | Order status when payment failed | Yes |

## 💡 Important Notes

### Currency Support
- **Placet Group only supports EUR (Euro) currency**
- The payment method will only appear when checkout currency is EUR
- Make sure EUR is enabled in: `System` → `Localisation` → `Currencies`

### Order Status Management
The extension automatically updates order status based on payment result:
- **Awaiting:** Payment initiated, waiting for customer action
- **Approved:** Payment successful, funds confirmed
- **Rejected:** Payment failed, declined, or cancelled

### Transaction ID
- Transaction ID is saved in the order's `payment_code` field
- Transaction ID also appears in order history comments
- View in: `Sales` → `Orders` → Click order → `History` tab

## 🔍 Troubleshooting

### Payment Method Not Showing
1. Check extension is **Enabled** in admin
2. Verify checkout currency is **EUR**
3. Check Geo Zone restrictions (if set)
4. Clear OpenCart cache: `System` → `Settings` → Click **Refresh** (cache icon)

### Order Status Not Updating
1. Check Order Status IDs are configured correctly
2. Check OpenCart error log: `system/storage/logs/error.log`
3. Verify API credentials are correct
4. Ensure callback URL is accessible (not blocked by firewall)

### API Connection Issues
1. Verify cURL is enabled in PHP
2. Check SSL certificate is valid
3. Check firewall allows outbound HTTPS connections
4. Test API URL is accessible from your server

## 🗑️ Uninstallation

1. **Disable the Extension:**
   - Go to: `Extensions` → `Extensions` → `Payments`
   - Find "Placet Group"
   - Click **Uninstall** button
   - **Note:** Database table is preserved to retain payment records

2. **Delete Files (Optional):**
   - Remove all extension files listed in Step 1

3. **Drop Database Table (Optional - Advanced Users Only):**
   - **WARNING:** This permanently deletes all payment records!
   - Only do this if you want to completely remove all data
   - Use the provided `uninstall.sql` file in phpMyAdmin
   - Or run: `DROP TABLE IF EXISTS oc_placetgroup_application;`

## 📞 Support

- **Placet Group Support:** Contact your Placet Group account manager
- **Technical Issues:** Check OpenCart error logs in `system/storage/logs/error.log`
- **Extension Version:** 1.0.0 for OpenCart 3.x

## 📄 File Structure

```
placetgroup-opencart3/
├── upload/
│   ├── admin/
│   │   ├── controller/extension/payment/placetgroup.php
│   │   ├── language/en-gb/extension/payment/placetgroup.php
│   │   └── view/template/extension/payment/placetgroup.twig
│   ├── catalog/
│   │   ├── controller/extension/payment/placetgroup.php
│   │   ├── language/en-gb/extension/payment/placetgroup.php
│   │   ├── model/extension/payment/placetgroup.php
│   │   └── view/theme/default/template/extension/payment/placetgroup.twig
│   └── system/
│       └── library/placetgroup.php
├── install.sql           (Reference only - not required for installation)
├── uninstall.sql         (Optional - for complete data removal)
└── README.md
```

## ✅ Compatibility

- ✅ OpenCart 3.0.0.0 - 3.0.3.9
- ✅ PHP 7.0 - 8.1
- ✅ MySQL 5.6+

## 📝 Changelog

### Version 1.0.0
- Initial release for OpenCart 3.x
- Full payment gateway integration
- Automatic order status updates
- Transaction ID tracking
- Custom order status creation
- Multi-language support ready

---

**License:** MIT  
**Author:** Custom Development  
**Date:** November 2025

