-- ============================================================================
-- Placet Group Payment Extension for OpenCart 3.x
-- Database Table Structure - REFERENCE ONLY
-- ============================================================================
--
-- IMPORTANT: You do NOT need to run this SQL manually!
-- 
-- The database table is created AUTOMATICALLY when you install the extension
-- in the OpenCart admin panel (Extensions → Payments → Install "Placet Group")
--
-- This file is included for:
-- - Documentation/reference purposes
-- - Manual recovery if automatic installation fails
-- - Advanced users who need to inspect database structure
--
-- If you must run manually (not recommended), replace 'oc_' with your
-- actual database prefix if different.
-- ============================================================================

CREATE TABLE IF NOT EXISTS `oc_placetgroup_application` (
  `application_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL,
  `order_id` int(11) DEFAULT NULL,
  `amount` decimal(15,4) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `currency_code` char(3) NOT NULL,
  `application_status` varchar(20) DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`application_id`),
  KEY `token` (`token`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- ============================================================================
-- End of file
-- ============================================================================
