<?php
/**
 * Placet Group Payment Gateway Admin Controller for OpenCart 3
 */
class ControllerExtensionPaymentPlacetgroup extends Controller {
    private $error = array();

    /**
     * Index - Display configuration page
     */
    public function index() {
        $this->load->language('extension/payment/placetgroup');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_placetgroup', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        // Error handling
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['url'])) {
            $data['error_url'] = $this->error['url'];
        } else {
            $data['error_url'] = '';
        }

        if (isset($this->error['partner_alias'])) {
            $data['error_partner_alias'] = $this->error['partner_alias'];
        } else {
            $data['error_partner_alias'] = '';
        }

        // Breadcrumbs
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/placetgroup', 'user_token=' . $this->session->data['user_token'], true)
        );

        // URLs
        $data['action'] = $this->url->link('extension/payment/placetgroup', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);
        $data['install_statuses'] = $this->url->link('extension/payment/placetgroup/installStatuses', 'user_token=' . $this->session->data['user_token'], true);

        // Configuration values
        if (isset($this->request->post['payment_placetgroup_url'])) {
            $data['payment_placetgroup_url'] = $this->request->post['payment_placetgroup_url'];
        } else {
            $data['payment_placetgroup_url'] = $this->config->get('payment_placetgroup_url');
        }

        if (isset($this->request->post['payment_placetgroup_partner_alias'])) {
            $data['payment_placetgroup_partner_alias'] = $this->request->post['payment_placetgroup_partner_alias'];
        } else {
            $data['payment_placetgroup_partner_alias'] = $this->config->get('payment_placetgroup_partner_alias');
        }

        if (isset($this->request->post['payment_placetgroup_awaiting_status_id'])) {
            $data['payment_placetgroup_awaiting_status_id'] = $this->request->post['payment_placetgroup_awaiting_status_id'];
        } else {
            $data['payment_placetgroup_awaiting_status_id'] = $this->config->get('payment_placetgroup_awaiting_status_id');
        }

        if (isset($this->request->post['payment_placetgroup_payment_status_id'])) {
            $data['payment_placetgroup_payment_status_id'] = $this->request->post['payment_placetgroup_payment_status_id'];
        } else {
            $data['payment_placetgroup_payment_status_id'] = $this->config->get('payment_placetgroup_payment_status_id');
        }

        if (isset($this->request->post['payment_placetgroup_rejected_status_id'])) {
            $data['payment_placetgroup_rejected_status_id'] = $this->request->post['payment_placetgroup_rejected_status_id'];
        } else {
            $data['payment_placetgroup_rejected_status_id'] = $this->config->get('payment_placetgroup_rejected_status_id');
        }

        if (isset($this->request->post['payment_placetgroup_geo_zone_id'])) {
            $data['payment_placetgroup_geo_zone_id'] = $this->request->post['payment_placetgroup_geo_zone_id'];
        } else {
            $data['payment_placetgroup_geo_zone_id'] = $this->config->get('payment_placetgroup_geo_zone_id');
        }

        if (isset($this->request->post['payment_placetgroup_status'])) {
            $data['payment_placetgroup_status'] = $this->request->post['payment_placetgroup_status'];
        } else {
            $data['payment_placetgroup_status'] = $this->config->get('payment_placetgroup_status');
        }

        if (isset($this->request->post['payment_placetgroup_sort_order'])) {
            $data['payment_placetgroup_sort_order'] = $this->request->post['payment_placetgroup_sort_order'];
        } else {
            $data['payment_placetgroup_sort_order'] = $this->config->get('payment_placetgroup_sort_order');
        }

        // Order Statuses
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // Geo Zones
        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/placetgroup', $data));
    }

    /**
     * Install custom order statuses
     */
    public function installStatuses() {
        $this->load->language('extension/payment/placetgroup');

        $json = array();

        if (!$this->user->hasPermission('modify', 'extension/payment/placetgroup')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            $this->load->model('localisation/order_status');

            // Create "Awaiting Placet Group Confirmation" status
            $awaitingStatusId = $this->createOrderStatus(array(
                'name' => 'Awaiting Placet Group Confirmation'
            ));

            // Create "Placet Group Payment Rejected" status
            $rejectedStatusId = $this->createOrderStatus(array(
                'name' => 'Placet Group Payment Rejected'
            ));

            if ($awaitingStatusId && $rejectedStatusId) {
                // Update configuration with new status IDs
                $this->load->model('setting/setting');
                
                $settings = array(
                    'payment_placetgroup_awaiting_status_id' => $awaitingStatusId,
                    'payment_placetgroup_rejected_status_id' => $rejectedStatusId
                );

                foreach ($settings as $key => $value) {
                    $this->db->query("DELETE FROM `" . DB_PREFIX . "setting` WHERE store_id = '0' AND `code` = 'payment_placetgroup' AND `key` = '" . $this->db->escape($key) . "'");
                    
                    $this->db->query("INSERT INTO `" . DB_PREFIX . "setting` SET 
                        store_id = '0', 
                        `code` = 'payment_placetgroup', 
                        `key` = '" . $this->db->escape($key) . "', 
                        `value` = '" . (int)$value . "', 
                        serialized = '0'
                    ");
                }

                $json['success'] = $this->language->get('text_status_success');
                $json['awaiting_status_id'] = $awaitingStatusId;
                $json['rejected_status_id'] = $rejectedStatusId;
            } else {
                $json['error'] = $this->language->get('error_status_creation');
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    /**
     * Create order status
     *
     * @param array $data Status data
     * @return int|false Status ID or false on failure
     */
    private function createOrderStatus($data) {
        // Check if status already exists
        $query = $this->db->query("SELECT order_status_id FROM `" . DB_PREFIX . "order_status` 
            WHERE name = '" . $this->db->escape($data['name']) . "' LIMIT 1");

        if ($query->num_rows > 0) {
            return (int)$query->row['order_status_id'];
        }

        // Get all languages
        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();

        $orderStatusId = 0;

        // Insert status name for each language
        foreach ($languages as $language) {
            if (!$orderStatusId) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "order_status` SET 
                    language_id = '" . (int)$language['language_id'] . "',
                    name = '" . $this->db->escape($data['name']) . "'
                ");
                $orderStatusId = $this->db->getLastId();
            } else {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "order_status` SET 
                    order_status_id = '" . (int)$orderStatusId . "',
                    language_id = '" . (int)$language['language_id'] . "',
                    name = '" . $this->db->escape($data['name']) . "'
                ");
            }
        }

        // Clear cache
        $this->cache->delete('order_status');

        return $orderStatusId;
    }

    /**
     * Install extension - create database table
     */
    public function install() {
        // Create the database table
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "placetgroup_application` (`application_id` int(11) NOT NULL AUTO_INCREMENT, `token` varchar(128) NOT NULL, `order_id` int(11) DEFAULT NULL, `amount` decimal(15,4) NOT NULL, `currency_id` int(11) NOT NULL, `currency_code` char(3) NOT NULL, `application_status` varchar(20) DEFAULT NULL, `date_added` datetime NOT NULL, `date_modified` datetime NOT NULL, PRIMARY KEY (`application_id`), KEY `token` (`token`), KEY `order_id` (`order_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
    }

    /**
     * Uninstall extension
     */
    public function uninstall() {
        // Note: We don't drop the table to preserve data
        // If you want to drop the table on uninstall, uncomment:
        // $this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "placetgroup_application`");
    }

    /**
     * Validate form data
     */
    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/placetgroup')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        // Validate URL
        if (empty($this->request->post['payment_placetgroup_url'])) {
            $this->error['url'] = $this->language->get('error_url');
        }

        // Validate Partner Alias
        if (empty($this->request->post['payment_placetgroup_partner_alias'])) {
            $this->error['partner_alias'] = $this->language->get('error_partner_alias');
        }

        return !$this->error;
    }
}

