<?php
/**
 * Placet Group Payment Gateway Catalog Model for OpenCart 3
 */
class ModelExtensionPaymentPlacetgroup extends Model {
    /**
     * Get Method
     *
     * This method is called by OpenCart's checkout to determine if this payment
     * method should be displayed and what options it has.
     *
     * @param array $address Customer address array
     * @param float $total Order total
     * @return array Payment method data or empty array if not available
     */
    public function getMethod($address, $total) {
        $this->load->language('extension/payment/placetgroup');

        // Check if payment method is enabled
        if (!$this->config->get('payment_placetgroup_status')) {
            return array();
        }

        // Check currency - only EUR is supported
        if ($this->session->data['currency'] != 'EUR') {
            return array();
        }

        // Check geo zone restrictions
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_placetgroup_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

        if (!$this->config->get('payment_placetgroup_geo_zone_id')) {
            $status = true;
        } elseif ($query->num_rows) {
            $status = true;
        } else {
            $status = false;
        }

        $method_data = array();

        if ($status) {
            $method_data = array(
                'code'       => 'placetgroup',
                'title'      => $this->language->get('text_title'),
                'terms'      => '',
                'sort_order' => $this->config->get('payment_placetgroup_sort_order')
            );
        }

        return $method_data;
    }
}

