/**
 * Placet Group Payment Method for WooCommerce Blocks
 */
( function() {
    const { registerPaymentMethod } = window.wc.wcBlocksRegistry;
    const { getSetting } = window.wc.wcSettings;
    const { decodeEntities } = window.wp.htmlEntities;
    const { createElement } = window.wp.element;

    const settings = getSetting( 'placet_group_data', {} );
    const label = decodeEntities( settings.title || 'Placet Järelmaks' );

    /**
     * Content component - displays payment method description
     */
    const Content = () => {
        const description = decodeEntities( settings.description || '' );
        return createElement( 'div', { dangerouslySetInnerHTML: { __html: description } } );
    };

    /**
     * Label component - displays payment method title and icon
     */
    const Label = ( props ) => {
        const { PaymentMethodLabel } = props.components;
        
        if ( settings.icon ) {
            return createElement(
                'div',
                { 
                    style: { 
                        display: 'flex', 
                        alignItems: 'center', 
                        gap: '8px',
                        width: '100%'
                    } 
                },
                createElement( PaymentMethodLabel, { text: label } ),
                createElement( 'img', {
                    src: settings.icon,
                    alt: label,
                    style: { 
                        maxHeight: '26px', 
                        maxWidth: '100px',
                        marginLeft: 'auto'
                    }
                } )
            );
        }
        
        return createElement( PaymentMethodLabel, { text: label } );
    };

    /**
     * Placet Group payment method configuration object
     */
    const PlacetGroupPaymentMethod = {
        name: 'placet_group',
        label: createElement( Label, null ),
        content: createElement( Content, null ),
        edit: createElement( Content, null ),
        canMakePayment: () => true,
        ariaLabel: label,
        supports: {
            features: settings.supports || []
        }
    };

    // Register the payment method
    registerPaymentMethod( PlacetGroupPaymentMethod );
} )();

