<?php
/**
 * Plugin Name: WooCommerce Placet Group Gateway
 * Plugin URI: https://placet.ee
 * Description: Placet Järelmaks payment gateway for WooCommerce with HPOS and Block Checkout support
 * Version: 2.0.1
 * Author: Placet Group
 * Text Domain: wc-placet-group
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 9.4
 *
 * @package WC_Placet_Group
 */

defined( 'ABSPATH' ) || exit;

// Define plugin constants
define( 'WC_PLACET_GROUP_VERSION', '2.0.1' );
define( 'WC_PLACET_GROUP_PLUGIN_FILE', __FILE__ );
define( 'WC_PLACET_GROUP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WC_PLACET_GROUP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Declare HPOS compatibility early
add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', WC_PLACET_GROUP_PLUGIN_FILE, true );
    }
} );

/**
 * Initialize the plugin
 */
add_action( 'plugins_loaded', 'wc_placet_group_init', 11 );

function wc_placet_group_init() {
    // Check if WooCommerce is active
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'wc_placet_group_missing_wc_notice' );
        return;
    }

    // Include the gateway class
    require_once WC_PLACET_GROUP_PLUGIN_DIR . 'includes/class-wc-placet-group-gateway.php';

    // Register the gateway
    add_filter( 'woocommerce_payment_gateways', 'wc_placet_group_add_gateway' );
}

/**
 * Register block support - Hook early to ensure it's registered before blocks initialize
 */
add_action( 'woocommerce_blocks_loaded', 'wc_placet_group_register_block_support' );

/**
 * Add Placet Group gateway to WooCommerce
 */
function wc_placet_group_add_gateway( $gateways ) {
    $gateways[] = 'WC_Placet_Group_Gateway';
    return $gateways;
}

/**
 * Display admin notice if WooCommerce is not active
 */
function wc_placet_group_missing_wc_notice() {
    echo '<div class="error"><p><strong>' . 
        sprintf(
            esc_html__( 'WooCommerce Placet Group Gateway requires WooCommerce to be installed and active. You can download %s here.', 'wc-placet-group' ),
            '<a href="https://woocommerce.com/" target="_blank">WooCommerce</a>'
        ) . '</strong></p></div>';
}

/**
 * Load plugin textdomain
 */
add_action( 'init', 'wc_placet_group_load_textdomain' );

function wc_placet_group_load_textdomain() {
    load_plugin_textdomain( 'wc-placet-group', false, dirname( plugin_basename( WC_PLACET_GROUP_PLUGIN_FILE ) ) . '/languages' );
}

/**
 * Register block checkout support
 */
function wc_placet_group_register_block_support() {
    if ( ! class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        return;
    }

    // Include the blocks support class
    require_once WC_PLACET_GROUP_PLUGIN_DIR . 'includes/class-wc-placet-group-blocks-support.php';

    // Register the payment method type
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function( $payment_method_registry ) {
            $payment_method_registry->register( new WC_Placet_Group_Blocks_Support() );
        }
    );
}

/**
 * Add plugin action links
 */
add_filter( 'plugin_action_links_' . plugin_basename( WC_PLACET_GROUP_PLUGIN_FILE ), 'wc_placet_group_action_links' );

function wc_placet_group_action_links( $links ) {
    $plugin_links = array(
        '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=placet_group' ) . '">' . 
            esc_html__( 'Settings', 'wc-placet-group' ) . 
        '</a>',
    );
    return array_merge( $plugin_links, $links );
}